/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Maze {
    char txtBlank = (char)32;
    char txtBlock = (char)9608;
    Block[][] grid;
    int width;
    int height;
    Random rand = new Random();

    public Maze(int n, int n2) {
        this.height = n2;
        this.width = n;
        this.grid = new Block[this.width][this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.grid[j][i] = new Block();
                if (i == this.height - 1) {
                    this.grid[j][i].join_bottom = false;
                }
                if (j != this.width - 1) continue;
                this.grid[j][i].join_right = false;
            }
        }
    }

    public void toText() {
        int n;
        int n2;
        int n3 = this.width * 2 + 1;
        int n4 = this.height * 2 + 1;
        char[][] cArray = new char[n3][n4];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                cArray[n][n2] = this.txtBlock;
            }
        }
        cArray[0][1] = 32;
        cArray[n3 - 1][n4 - 2] = 32;
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                cArray[n * 2 + 1][n2 * 2 + 1] = 32;
                if (this.grid[n][n2].join_bottom) {
                    cArray[n * 2 + 1][n2 * 2 + 2] = 32;
                }
                if (!this.grid[n][n2].join_right) continue;
                cArray[n * 2 + 2][n2 * 2 + 1] = 32;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                System.out.print(cArray[n][n2]);
            }
            System.out.print('\n');
        }
    }

    public void toHTML() {
        System.out.println("<style type=\"text/css\">");
        System.out.println("td { height: 1em; width: 1em; }");
        System.out.println("</style>");
        System.out.println("<table style=\"border-collapse:collapse;\">");
        for (int i = 0; i < this.height; ++i) {
            System.out.println("\t<tr>");
            for (int j = 0; j < this.width; ++j) {
                String string = "";
                if (j == 0 && i != 0) {
                    string = string + " border-left: 1px solid #000;";
                }
                if (i == 0) {
                    string = string + " border-top: 1px solid #000;";
                }
                if (!this.grid[j][i].join_bottom) {
                    string = string + " border-bottom: 1px solid #000;";
                }
                if (!(this.grid[j][i].join_right || i == this.height - 1 && j == this.width - 1)) {
                    string = string + " border-right: 1px solid #000;";
                }
                if ((string = string.trim()).equals("")) {
                    System.out.println("\t\t<td></td>");
                    continue;
                }
                System.out.println("\t\t<td style=\"" + string + "\"></td>");
            }
            System.out.println("\t</tr>");
        }
        System.out.println("</table>");
    }

    public boolean generateDepthFirstSearch() {
        int n = this.randomInt(0, this.width - 1);
        int n2 = this.randomInt(0, this.height - 1);
        this.followUp(n, n2, n, n2);
        return true;
    }

    private boolean followUp(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n == this.width || n2 == this.height) {
            return false;
        }
        this.grid[n][n2].visited = true;
        int[] nArray = this.randomise(new int[]{0, 1, 2, 3});
        block6: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 0: {
                    if (n2 + 1 == this.height) continue block6;
                    if (!this.grid[n][n2 + 1].visited) {
                        this.followUp(n, n2 + 1, n, n2);
                        continue block6;
                    }
                    if (n3 == n && n4 == n2 + 1) continue block6;
                    this.grid[n][n2].join_bottom = false;
                    continue block6;
                }
                case 1: {
                    if (n + 1 == this.width) continue block6;
                    if (!this.grid[n + 1][n2].visited) {
                        this.followUp(n + 1, n2, n, n2);
                        continue block6;
                    }
                    if (n3 == n + 1 && n4 == n2) continue block6;
                    this.grid[n][n2].join_right = false;
                    continue block6;
                }
                case 2: {
                    if (n - 1 == -1) continue block6;
                    if (!this.grid[n - 1][n2].visited) {
                        this.followUp(n - 1, n2, n, n2);
                        continue block6;
                    }
                    if (n3 == n - 1 && n4 == n2) continue block6;
                    this.grid[n - 1][n2].join_right = false;
                    continue block6;
                }
                case 3: {
                    if (n2 - 1 == -1) continue block6;
                    if (!this.grid[n][n2 - 1].visited) {
                        this.followUp(n, n2 - 1, n, n2);
                        continue block6;
                    }
                    if (n3 == n && n4 == n2 - 1) continue block6;
                    this.grid[n][n2 - 1].join_bottom = false;
                }
            }
        }
        return true;
    }

    private int randomInt(int n, int n2) {
        return this.rand.nextInt(n2 - n + 1) + n;
    }

    private int[] randomise(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            int n2 = this.randomInt(0, nArray.length - 1);
            if (nArray[n2] == -1) continue;
            nArray2[n] = nArray[n2];
            nArray[n2] = -1;
            ++n;
        }
        return nArray2;
    }

    public void generatePrim() {
        int n = this.randomInt(0, this.width - 1);
        int n2 = this.randomInt(0, this.height - 1);
    }
}

