/* MazeGenerator - Create a maze with depth-first search

Copyright (C) 2012 Michael Billington <michael.billington@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
public class MazeGenerator {
	public static void main(String args[]) {
		/* Defaults */
		int width = 10;
		int height = 10;
		char txtBlock = '\u2588';
		boolean doHTML = false;

		if (args.length >= 2) {
			/* Gather info from command line */
			width = Integer.parseInt(args[0]);
			height = Integer.parseInt(args[1]);
		}
		if(args.length >= 3) {
			if(args[2].equals("html")) {
				doHTML = true;
			} else {
				txtBlock = args[2].charAt(0);
			}
		}

		/* Generate maze and output */
		Maze maze = new Maze(width, height);
		maze.txtBlock = txtBlock;
		maze.generateDepthFirstSearch();
		if(!doHTML) {
			maze.toText();
		} else {
			maze.toHTML();
		}
	}
}
